# 项目概述
主体框架为spring boot,接口是restful风格，登录使用spring security的token做认证，token使用redis做了存储，数据访问使用mybatis，
数据连接池用druid，数据库为mysql。
# 配置文件
1. application.yml
    * 数据库、spring等系统主要配置都在此文件
2. properties/domain.properties
    * 自定义的一些配置，比如邮箱、stripe账号、腾讯ai相关的配置等等
3. logback-spring.xml
    * 日志配置文件
    
# 爬虫规范及文档

[爬虫文档链接](../doc/SpiderSpecification.md)

# 项目层次结构
项目大致分为两个包和相关的资源文件，两个包分别是com.diaoyun.zion.master和com.diaoyun.zion.chinafrica。
1. master这个包下面放的是项目通用的类，比如项目模块配置类、异常处理、spring security相关的东西。
    * base 放的是基类
    * bo 业务用到的封装类
    * captcha 邮箱发送验证码相关的类，源邮箱需要开启 SMTP、POP3服务
    * common 公用的功能类，比如redis、管理token相关的类
    * config 项目模块注册的配置类。比如redis、mysql扫描、freemarker（生成邮件模板）、swagger文档等等
    * dao 数据访问基类
    * enums 枚举类
    * exception 异常处理相关
    * gson。spring boot默认使用jackson 作为将返回结果转化为json字符串的工具类，但是jackson在转化比较复杂的返
    回结果时会出问题，而gson可以比较完美的序列化，所以项目中使用gson替代默认的jackson。
    * listener 监听器，目前监听订单的过期，再取消订单。为此redis需要确保redis.conf(在redis安装路径下)
    已添加配置
    ```properties
    notify-keyspace-events Ex
    ```
    * security 放的是spring security、jwt相关的文件。代码参照以下项目，详细可点击查看  
    [https://github.com/murraco/spring-boot-jwt](https://github.com/murraco/spring-boot-jwt)
    * thread 存放线程相关类，主要是翻译所用多线程
    * util 一些工具类
    * validator 数据验证相关的类
2. chinafrica放的是非洲app的业务相关的东西
    * api 放的是提供给第三方的接口
    * bis 业务类，目前有爬虫和stripe支付
    * client 登录认证相关
    * constant 一些常量
    * controller 非洲app业务相关的控制层
    * dao 非洲app业务相关的数据访问层
    * entity 非洲app业务相关的数据层实体类
    * enums 非洲app业务相关的枚举
    * factory 工厂类
    * service  非洲app业务相关的服务类
    * vo 非洲app业务相关的业务数据映射类
3. 资源文件
    * mapper 数据库映射文件
    * mybatis mybatis配置文件
    * properties 自定义的配置文件
    * static 静态资源，系统能直接访问目录下的文件
    * templates 页面模板文件，目前只有一个邮件模板
    * banner.txt 启动显示文字
    * logback-spring.xml 日志配置文件
4. test 包
    * 略
# 接口文档地址
[http://localhost:8083/zion/swagger-ui.html](http://localhost:8083/zion/swagger-ui.html)