/*
 * Decompiled with CFR 0.152.
 */
package com.github.theresasogunle;

import com.github.theresasogunle.Charge;
import com.github.theresasogunle.Encryption;
import com.github.theresasogunle.Polling;
import com.github.theresasogunle.RaveConstant;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountCharge {
    Encryption e = new Encryption();
    private String accountnumber;
    private String accountbank;
    private String currency;
    private String country;
    private String amount;
    private String email;
    private String phonenumber;
    private String firstname;
    private String lastname;
    private String IP;
    private String txRef;
    private String passcode;
    private String device_fingerprint;
    private String transaction_reference;
    private String otp;

    public JSONObject setJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put("PBFPubKey", RaveConstant.PUBLIC_KEY);
            json.put("accountnumber", this.getAccountnumber());
            json.put("accountbank", this.getAccountbank());
            json.put("currency", this.getCurrency());
            json.put("country", this.getCountry());
            json.put("amount", this.getAmount());
            json.put("firstname", this.getFirstname());
            json.put("lastname", this.getLastname());
            json.put("passcode", this.getPasscode());
            json.put("email", this.getEmail());
            json.put("IP", this.getIP());
            json.put("payment_type", "account");
            json.put("txRef", this.getTxRef());
            json.put("device_fingerprint", this.getDevice_fingerprint());
        }
        catch (JSONException ex) {
            ex.getMessage();
        }
        return json;
    }

    public JSONObject chargeAccount() {
        JSONObject json = this.setJSON();
        String message = json.toString();
        String encrypt_secret_key = Encryption.getKey(RaveConstant.SECRET_KEY);
        String client = Encryption.encryptData(message, encrypt_secret_key);
        Charge ch = new Charge();
        return ch.charge(client);
    }

    public JSONObject chargeAccount(boolean polling) {
        JSONObject json = this.setJSON();
        Polling p = new Polling();
        return p.handleTimeoutCharge(json);
    }

    public JSONObject validateAccountCharge() {
        Charge vcharge = new Charge();
        return vcharge.validateAccountCharge(this.getTransaction_reference(), this.getOtp());
    }

    public JSONObject validateAccountCharge(boolean polling) {
        Polling p = new Polling();
        return p.validateAccountChargeTimeout(this.getTransaction_reference(), this.getOtp());
    }

    public String getAccountnumber() {
        return this.accountnumber;
    }

    public AccountCharge setAccountnumber(String accountnumber) {
        this.accountnumber = accountnumber;
        return this;
    }

    public String getAccountbank() {
        return this.accountbank;
    }

    public AccountCharge setAccountbank(String accountbank) {
        this.accountbank = accountbank;
        return this;
    }

    public String getCurrency() {
        return this.currency;
    }

    public AccountCharge setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public String getCountry() {
        return this.country;
    }

    public AccountCharge setCountry(String country) {
        this.country = country;
        return this;
    }

    public String getAmount() {
        return this.amount;
    }

    public AccountCharge setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public AccountCharge setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhonenumber() {
        return this.phonenumber;
    }

    public AccountCharge setPhonenumber(String phonenumber) {
        this.phonenumber = phonenumber;
        return this;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public AccountCharge setFirstname(String firstname) {
        this.firstname = firstname;
        return this;
    }

    public String getLastname() {
        return this.lastname;
    }

    public AccountCharge setLastname(String lastname) {
        this.lastname = lastname;
        return this;
    }

    public String getIP() {
        return this.IP;
    }

    public AccountCharge setIP(String IP) {
        this.IP = IP;
        return this;
    }

    public String getTxRef() {
        return this.txRef;
    }

    public AccountCharge setTxRef(String txRef) {
        this.txRef = txRef;
        return this;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public AccountCharge setPasscode(String passcode) {
        this.passcode = passcode;
        return this;
    }

    public String getDevice_fingerprint() {
        return this.device_fingerprint;
    }

    public AccountCharge setDevice_fingerprint(String device_fingerprint) {
        this.device_fingerprint = device_fingerprint;
        return this;
    }

    public String getTransaction_reference() {
        return this.transaction_reference;
    }

    public AccountCharge setTransaction_reference(String transaction_reference) {
        this.transaction_reference = transaction_reference;
        return this;
    }

    public String getOtp() {
        return this.otp;
    }

    public AccountCharge setOtp(String otp) {
        this.otp = otp;
        return this;
    }
}

