package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.math.BigDecimal;
import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * Zara 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.ZaraSpider
 * @author 爱酱油不爱醋
 */
public class ZaraSpiderParse {

    /**
     * 获取主要数据
     * @param content 商品的 HTML 页面
     * @return 截取后的主要数据
     */
    public static JSONObject getJsonData(String content) {
        int labelHeadIndex = content.indexOf("dataLayer");
        int labelTailIndex = content.lastIndexOf(";window.zara.viewPayload");
        String abv = content.substring(labelHeadIndex, labelTailIndex).replace("dataLayer = ", "");
        JSONObject dataMap= JSONObject.fromObject(abv);
        return dataMap;
    }

    /**
     * 格式化返回数据
     * @param dataMap 主要的 json 数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName("Zara");
        itemInfo.setShopUrl(dataMap.getString("backUrl"));
        JSONObject productObj = dataMap.getJSONObject("product");
        itemInfo.setItemId(productObj.getString("id"));
        itemInfo.setTitle(productObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        // 取 colors 节点数组
        JSONArray colorsArr = productObj.getJSONObject("detail").getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            // 取 detailImagesArr 节点数组第一个对象
            JSONObject detailImagesObj_0 = colorsObj.getJSONArray("detailImages").getJSONObject(0);
            // 处理图片 参考路径：http://static.zara.cn/photos///2019/I/0/1/p/0858/457/800/17/w/1920/0858457800_1_1_1.jpg?ts=1570720340221
            String imageUrl = "http://static.zara.cn/photos//"
                    + detailImagesObj_0.getString("path")
                    + "w/1920/"
                    + detailImagesObj_0.getString("name")
                    + "_1.jpg?ts="
                    + detailImagesObj_0.getString("timestamp");

            if (i == 0) {
                // 商品基本信息--设置：图片
                itemInfo.setPic(imageUrl);
            }

            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
            Set<ProductProp> propSet = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            // 颜色描述
            productPropColor.setPropId(colorsObj.getString("productId"));
            productPropColor.setPropName(colorsObj.getString("name"));
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            // 取 sizes 节点数组
            JSONArray sizesArr = colorsArr.getJSONObject(i).getJSONArray("sizes");
            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                // 库存对应的id(Zara 中以颜色id + 尺码id)
                String skuStr = ";" + colorsObj.getString("productId") + ";" + sizesObj.getString("sku") + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，Zara 未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld=new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_DOWN);

                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(priceNew.toString());
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////

                ///////////////////////// 获取商品尺码属性 ////////////////////
                Set<ProductProp> sizePropSet = new HashSet<>();
                ProductProp productPropSize = new ProductProp();
                String size = sizesObj.getString("name");
                productPropSize.setPropId(sizesObj.getString("sku"));
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

            }
        }

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.ZARA.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
