package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * UrbanRevivo 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.UrbanRevivoSpider
 * @author 爱酱油不爱醋
 */
public class UrbanRevivoSpiderParse {

    /**
     * 格式化返回数据
     * @param dataMap 主要的 json 数据
     * @param pId 截取的商品 id
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 取 data 数据节点
        JSONObject dataObj = dataMap.getJSONObject("data");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName(PlatformEnum.URBANREVIVO.getLabel());
        itemInfo.setShopUrl("http://www.ur.cn/index.html");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(dataObj.getString("name"));
        itemInfo.setPic("https://gw-img.ur.com.cn//" + dataObj.getString("image"));
        //////////////////////////////////// 获取商品基本信息End////////////////////////////////////////////

        // 取 colors 节点数组
        JSONArray colorsArr = dataObj.getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            // 获取图片路径
            String imgUrl = "https://gw-img.ur.com.cn//" + colorsObj.getString("image");

            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
            Set<ProductProp> propSet = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            String colorNo = colorsObj.getString("productColorId");
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(colorsObj.getString("aliasName"));
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            // 取 skus 节点数组
            JSONArray skusArr = colorsObj.getJSONArray("skus");
            for (int j = 0; j < skusArr.size(); j++) {
                JSONObject skusObj = skusArr.getJSONObject(j);

                ///////////////////////// 获取商品尺码属性 ////////////////////
                Set<ProductProp> sizePropSet = new HashSet<>();
                ProductProp productPropSize = new ProductProp();
                String sizeNo = skusObj.getString("barCode");
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(skusObj.getString("sizeAlias"));
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 设置库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = dataObj.getString("tagPrice");
                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(fullPrice);
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////

            }

        }

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.URBANREVIVO.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}

