package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * Lily 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.LilySpider
 * @author 爱酱油不爱醋
 */
public class LilySpiderParse {

    /**
     * 格式化返回数据
     * TODO 未完成
     * @param content 主要的商品内容
     * @param pId 商品id
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(String content, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        // 获取商品的价格、颜色、标题、图片、尺码属性
        String fullPrice = document.select("input[id=salePrice]").attr("value");
        String pColor = document.select("input[id=colorDisPaly]").attr("value");
        String pTitle = document.select("input[id=itemTitle]").attr("value");
        String pImg = document.select("input[id=shoppingcartpic]").attr("value");
        List<String> pSizeList = document.select("div[class=overview product-size]")
                .select("ul").select("li").eachText();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        ItemInfo itemInfo = new ItemInfo();


        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.ZARA.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
