package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfTakeCouponEntity;

import java.util.List;
import java.util.Map;

/**
 * 用户领取优惠券列表Service接口
 *
 * @author lipengjun
 * @date 2019-08-29 11:33:33
 */
public interface TbCfTakeCouponService {

    /**
     * 根据主键查询实体
     *
     * @param takeId 主键
     * @return 实体
     */
    TbCfTakeCouponEntity queryObject(String takeId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfTakeCouponEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfTakeCoupon 实体
     * @return 保存条数
     */
    int save(TbCfTakeCouponEntity tbCfTakeCoupon);

    /**
     * 根据主键更新实体
     *
     * @param tbCfTakeCoupon 实体
     * @return 更新条数
     */
    int update(TbCfTakeCouponEntity tbCfTakeCoupon);

    /**
     * 根据主键删除
     *
     * @param takeId
     * @return 删除条数
     */
    int delete(String takeId);

    /**
     * 根据主键批量删除
     *
     * @param takeIds
     * @return 删除条数
     */
    int deleteBatch(String[] takeIds);
}
