package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 站点商品Service接口
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfStationItemService {

    /**
     * 根据主键查询实体
     *
     * @param itemId 主键
     * @return 实体
     */
    TbCfStationItemEntity queryObject(String itemId);

    /**
     * 根据主键一级分类实体集合
     *
     * @return List集合
     */
    List<TbCfStationItemEntity> getGoodsTypeList(String categoryId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfStationItemEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfStationItem 实体
     * @return 保存条数
     */
    int save(TbCfStationItemEntity tbCfStationItem);

    /**
     * 根据主键更新实体
     *
     * @param tbCfStationItem 实体
     * @return 更新条数
     */
    int update(TbCfStationItemEntity tbCfStationItem);

    /**
     * 根据主键删除
     *
     * @param itemId
     * @return 删除条数
     */
    int delete(String itemId);

    /**
     * 根据主键批量删除
     *
     * @param itemIds
     * @return 删除条数
     */
    int deleteBatch(String[] itemIds);

    /**
     * 获取商品独立站
     * @param pageNum
     * @param pageSize
     * @return
     */
    Result getItemStationList(Integer pageNum, Integer pageSize,String categoryId);
}
