package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfPlatformOrderEntity;

import java.util.List;
import java.util.Map;

/**
 * 第三方平台对应订单信息Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfPlatformOrderService {

    /**
     * 根据主键查询实体
     *
     * @param relativeId 主键
     * @return 实体
     */
    TbCfPlatformOrderEntity queryObject(String relativeId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfPlatformOrderEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfPlatformOrder 实体
     * @return 保存条数
     */
    int save(TbCfPlatformOrderEntity tbCfPlatformOrder);

    /**
     * 根据主键更新实体
     *
     * @param tbCfPlatformOrder 实体
     * @return 更新条数
     */
    int update(TbCfPlatformOrderEntity tbCfPlatformOrder);

    /**
     * 根据主键删除
     *
     * @param relativeId
     * @return 删除条数
     */
    int delete(String relativeId);

    /**
     * 根据主键批量删除
     *
     * @param relativeIds
     * @return 删除条数
     */
    int deleteBatch(String[] relativeIds);
}
