package com.diaoyun.zion.chinafrica.factory;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.SpringContextUtil;

/**
 * 商品爬虫工厂类
 *
 * @author G
 */
public class ItemSpiderFactory {

    /**
     * 根据获取的路径选择对应的爬虫
     * @param platformEnum 爬虫枚举
     * @return 爬虫实现类
     */
    public static IItemSpider getSpider(PlatformEnum platformEnum) {
        IItemSpider iItemSpider;
        switch (platformEnum.getValue()) {
            case "tb": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("tbItemSpider");
                break;
            }
            case "tm": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("tmItemSpider");
                break;
            }
            case "pullandbear": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("pullandbearSpider");
                break;
            }
            case "gap": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("gapItemSpider");
                break;
            }
            case "zara": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("zaraSpider");
                break;
            }
            case "uniqlo": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("uniqloSpider");
                break;
            }
            case "nike": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("nikeItemSpider");
                break;
            }
            case "adidas": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("adidasSpider");
                break;
            }
            case "hm": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("hmSpider");
                break;
            }
            case "lily": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("lilySpider");
                break;
            }
            case "urbanrevivo": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("urbanrevivoSpider");
                break;
            }
            case "underarmour": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("underarmourSpider");
                break;
            }
            case "ochirly": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("ochirlySpider");
                break;
            }
            case "esprit": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("espritSpider");
                break;
            }
            case "levi": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("leviSpider");
                break;
            }
            case "moco": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("mocoSpider");
                break;
            }
            case "massimodutti": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("massimoduttiSpider");
                break;
            }
            case "afri-eshop":{
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("africaShopItemSpider");
                break;
            }
            default: {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("emptyItemSpider");
                break;
            }
        }
        return iItemSpider;
    }

}
