package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfVersionEntity;
import com.diaoyun.zion.chinafrica.service.TbCfVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/version")
public class VersionController {

    @Autowired
    private TbCfVersionService tbCfVersionService;

    @RequestMapping("/getVersionCode")
    @GetMapping
    public Map<String, TbCfVersionEntity> getGoodsTypeList( @RequestParam(required = false) String code) {
        Map<String,TbCfVersionEntity> map = new HashMap<>();
        TbCfVersionEntity version = tbCfVersionService.getVersionCode(code);
        map.put("data",version);
        return map;
    }
}
