package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfProblemService;
import com.diaoyun.zion.master.base.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * 常见问题Controller
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Api(tags = "常见问题")
@RestController
@RequestMapping("/problem")
public class TbCfProblemController {
    @Autowired
    private TbCfProblemService tbCfProblemService;


    @ApiOperation("获取常见问题 默认10条")
    @GetMapping
    public Result<PageInfo> getProblemList(@ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                                           @ApiParam(value ="每页大小") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return tbCfProblemService.getProblemList(pageNum, pageSize);

    }

}
