package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.spider.UrbanRevivoSpiderParse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * UrbanRevivo 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("urbanrevivoSpider")
public class UrbanRevivoSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * UrbanRevivo 商品详情页Url
     */
    private static final String UrbanRevivo_URL = "http://wap.ur.com.cn/product/detail";

    /**
     * UrbanRevivo 数据爬虫
     * @see UrbanRevivoSpiderParse#formatProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中商品的 id
        String[] split = targetUrl.split("productColorId=");
        String pId = split[1];
        System.err.println(pId);
        // 访问数据接口
        targetUrl = "http://wap.ur.com.cn/product/product/detail?id=" + pId;
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.URBANREVIVO.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        // 格式化数据
        ProductResponse productResponse = UrbanRevivoSpiderParse.formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        // 翻译数据
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

}