package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * H&M 数据爬虫
 *
 * TODO 数据被处理，尚未方法爬取
 *
 * @author 爱酱油不爱醋
 */
@Component("hmSpider")
public class HmSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(UniqloSpider.class);

    /**
     * H&M 详情商品页url
     */
    private static final String H_M_URL = "https://www2.hm.com/zh_cn/productpage";

    /**
     * H&M 数据格式化
     * @param targetUrl
     * @return
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.HM.getValue());
        String detailStr = JsoupUtil.getScriptContent(content, "productArticleDetails");
        int firstBrackets=detailStr.indexOf("{");
        int lastbrackets=detailStr.lastIndexOf("}");
        String resultStr = detailStr.substring(firstBrackets,lastbrackets+1);
        int firstImage = detailStr.indexOf("'images':[");
        int lastImage = detailStr.lastIndexOf("'video':");
        detailStr = detailStr.substring(firstImage, lastImage);
        resultStr = resultStr.replace(detailStr, "");
        JSONObject resultObj = JSONObject.fromObject(resultStr);
        return resultObj;
    }

    public static void main(String[] args) throws Exception {
        String targetUrl = "https://www2.hm.com/zh_cn/productpage.0754698003.html";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARA.getValue());
        String detailStr = JsoupUtil.getScriptContent(content, "productArticleDetails");
        int firstBrackets=detailStr.indexOf("{");
        int lastbrackets=detailStr.lastIndexOf("}");
        String resultStr = detailStr.substring(firstBrackets,lastbrackets+1);
        resultStr = resultStr.replace("isDesktop ? ", "");
        String regexp = "\'";
        resultStr = resultStr.replaceAll(regexp, "\"");
        JSONObject resultObj = JSONObject.fromObject(resultStr);
        System.err.println(resultObj);
    }

}
