package com.diaoyun.zion.master.thread;

import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.SortUtil;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.http.Consts;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;

/*腾讯ai 基类*/
public abstract class AbstractTencentCallable<T> implements Callable<Map<String, Object>> {
    //申请的app_id
    protected Integer app_id;
    //申请的app_url
    protected String app_url;

    protected T param;
    //编码方式
    protected String charset;

    @Override
    public Map<String, Object> call() throws Exception {
        //logger.info("call()方法被自动调用！！！    " + Thread.currentThread().getName());
        Map<String, Object> paramMap = BeanUtils.describe(param);
        // TODO 去除class说明，或许可以尝试别的方法
        paramMap.remove("class");
        SortedMap<String, Object> sortMap = new TreeMap<String, Object>(paramMap);
        String sign = SortUtil.createSign(sortMap,charset);
        paramMap.put("sign", sign);
        //发送请求
        String resultStr = HttpClientUtil.createConnection(this.app_url, paramMap,charset);
        Map<String, Object> resultMap = JSONObject.fromObject(resultStr);
        return resultMap;
    }

    abstract void fillParam(T param);
}
