package com.diaoyun.zion.master.security;

import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.impl.TbCfUserInfoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class MyUserDetails implements UserDetailsService {

  @Autowired
  private TbCfUserInfoServiceImpl tbCfUserInfoService;

  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    final TbCfUserInfoEntity user = tbCfUserInfoService.findByAccount(username);

    if (user == null) {
      throw new UsernameNotFoundException("User '" + username + "' not found or disable");
    }

    return org.springframework.security.core.userdetails.User//
        .withUsername(username)//
        .password(user.getPassword())//
        .authorities("ROLE_ADMIN")//
        .accountExpired(false)//
        .accountLocked(false)//
        .credentialsExpired(false)//
        .disabled(false)//
        .build();
  }

}
