package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfCategoryHsDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCategoryHsEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCategoryHsService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 商品报关品名表（从第三方合作商拿过来的）Service实现类
 *
 * @author lipengjun
 * @date 2019-08-30 09:54:02
 */
@Service("tbCfCategoryHsService")
public class TbCfCategoryHsServiceImpl implements TbCfCategoryHsService {
    @Autowired
    private TbCfCategoryHsDao tbCfCategoryHsDao;

    @Override
    public TbCfCategoryHsEntity queryObject(String categoryId) {
        return tbCfCategoryHsDao.queryObject(categoryId);
    }

    @Override
    public List<TbCfCategoryHsEntity> queryList(Map<String, Object> map) {
        return tbCfCategoryHsDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfCategoryHsDao.queryTotal(map);
    }

    @Override
    public int save(TbCfCategoryHsEntity tbCfCategoryHs) {
        tbCfCategoryHs.setCategoryId(IdUtil.createIdbyUUID());
        return tbCfCategoryHsDao.save(tbCfCategoryHs);
    }

    @Override
    public int update(TbCfCategoryHsEntity tbCfCategoryHs) {
        return tbCfCategoryHsDao.update(tbCfCategoryHs);
    }

    @Override
    public int delete(String categoryId) {
        return tbCfCategoryHsDao.delete(categoryId);
    }

    @Override
    public int deleteBatch(String[] categoryIds) {
        return tbCfCategoryHsDao.deleteBatch(categoryIds);
    }
}
