package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfOrderEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfOrderVo;
import com.diaoyun.zion.master.base.Result;
import com.stripe.exception.StripeException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfOrderService {

    /**
     * 根据主键查询实体
     *
     * @param orderId 主键
     * @return 实体
     */
    TbCfOrderEntity queryObject(String orderId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfOrderEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfOrder 实体
     * @return 保存条数
     */
    int save(TbCfOrderEntity tbCfOrder);

    /**
     * 根据主键更新实体
     *
     * @param tbCfOrder 实体
     * @return 更新条数
     */
    int update(TbCfOrderEntity tbCfOrder);

    /**
     * 根据主键删除
     *
     * @param orderId
     * @return 删除条数
     */
    int delete(String orderId);

    /**
     * 根据主键批量删除
     *
     * @param orderIds
     * @return 删除条数
     */
    int deleteBatch(String[] orderIds);

    /**
     * 用户结算
     *
     * @return
     */
    Result settleAccount() throws IOException, URISyntaxException, ExecutionException, InterruptedException, TimeoutException;

    /**
     * 用户下单
     *
     * @param tbCfOrderVo
     * @return
     */
    Result placeOrder(TbCfOrderVo tbCfOrderVo) throws IOException, URISyntaxException, ExecutionException, InterruptedException, TimeoutException;

    /**
     * 获取用户订单列表
     * @param orderStatus 订单状态 OrderStatusEnum
     * @return
     */
    Result getUserOrderList(Integer pageNum, Integer pageSize,Integer orderStatus);

    /**
     * 取消订单
     *
     * @param orderId
     * @param userId
     * @param couponId
     */
    void cancelOrder(String orderId, String userId, String couponId);

    /**
     * 获取stripe公钥
     *
     * @return
     */
    Result getStripePublicKey();

    /**
     * 支付订单
     *
     * @param orderId
     * @return
     */
    Result payForOrder(String orderId, String token) ;

    /**
     * 根据订单id，获取物流详情
     * @param orderId
     * @return
     */
    Result queryOrderExpressInfo(String orderId) throws IOException;

    /**
     * 获取某段时间内的付款订单
     * @param beginTime
     * @param endTime
     * @param pageNum
     * @param pageSize
     * @return
     */
    Result getOrderListByTime(long beginTime, long endTime, Integer pageNum, Integer pageSize);

    /**
     * 获取某段时间已发货订单数据
     * @param beginTime
     * @param endTime
     * @param pageNum
     * @param pageSize
     * @return
     */
    Result getDeliveryList(long beginTime, long endTime, Integer pageNum, Integer pageSize);

    /**
     * 根据订单号获取详细订单数据 给第三方的接口
     * @param orderId
     * @return
     */
    Result getOrderDetailThird(String orderId);

    /**
     * 删除订单 伪删除
     * @param orderId
     * @return
     */
    Result deleteOrder(String orderId);

    /**
     * 根据订单号获取详细订单数据 内部使用
     * @param orderId
     * @return
     */
    Result getOrderDetail(String orderId);
}
