package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfItemOrderREntity;

import java.util.List;
import java.util.Map;

/**
 * 订单商品对应表Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfItemOrderRService {

    /**
     * 根据主键查询实体
     *
     * @param orderItemId 主键
     * @return 实体
     */
    TbCfItemOrderREntity queryObject(String orderItemId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfItemOrderREntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfItemOrderR 实体
     * @return 保存条数
     */
    int save(TbCfItemOrderREntity tbCfItemOrderR);

    /**
     * 根据主键更新实体
     *
     * @param tbCfItemOrderR 实体
     * @return 更新条数
     */
    int update(TbCfItemOrderREntity tbCfItemOrderR);

    /**
     * 根据主键删除
     *
     * @param orderItemId
     * @return 删除条数
     */
    int delete(String orderItemId);

    /**
     * 根据主键批量删除
     *
     * @param orderItemIds
     * @return 删除条数
     */
    int deleteBatch(String[] orderItemIds);
}
