package com.diaoyun.zion.chinafrica.service;


import com.diaoyun.zion.chinafrica.entity.TbCfFeedbackRecordEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfFeedbackRecordListVo;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 用户反馈记录表Service接口
 *
 * @author lipengjun
 * @date 2019-09-21 15:15:23
 */
public interface TbCfFeedbackRecordService {

    /**
     * 根据主键查询实体
     *
     * @param recordId 主键
     * @return 实体
     */
    TbCfFeedbackRecordEntity queryObject(String recordId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfFeedbackRecordEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfFeedbackRecord 实体
     * @return 保存条数
     */
    int save(TbCfFeedbackRecordEntity tbCfFeedbackRecord);

    /**
     * 根据主键更新实体
     *
     * @param tbCfFeedbackRecord 实体
     * @return 更新条数
     */
    int update(TbCfFeedbackRecordEntity tbCfFeedbackRecord);

    /**
     * 根据主键删除
     *
     * @param recordId
     * @return 删除条数
     */
    int delete(String recordId);

    /**
     * 根据主键批量删除
     *
     * @param recordIds
     * @return 删除条数
     */
    int deleteBatch(String[] recordIds);

    /**
     * 保存客户反馈
     * @param tbCfFeedbackRecordEntity
     * @return
     */
    Result saveFeedback(TbCfFeedbackRecordEntity tbCfFeedbackRecordEntity);

    /**
     * 批量保存客户反馈
     * @param tbCfFeedbackRecordListVo
     * @return
     */
    Result saveFeedbackList(TbCfFeedbackRecordListVo tbCfFeedbackRecordListVo);
}
