package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfExpCatRelEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 快递模板与商品种类关联表Service接口
 *
 * @author lipengjun
 * @date 2019-08-30 09:47:20
 */
public interface TbCfExpCatRelService {

    /**
     * 根据主键查询实体
     *
     * @param relateId 主键
     * @return 实体
     */
    TbCfExpCatRelEntity queryObject(String relateId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfExpCatRelEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfExpCatRel 实体
     * @return 保存条数
     */
    int save(TbCfExpCatRelEntity tbCfExpCatRel);

    /**
     * 根据主键更新实体
     *
     * @param tbCfExpCatRel 实体
     * @return 更新条数
     */
    int update(TbCfExpCatRelEntity tbCfExpCatRel);

    /**
     * 根据主键删除
     *
     * @param relateId
     * @return 删除条数
     */
    int delete(String relateId);

    /**
     * 根据主键批量删除
     *
     * @param relateIds
     * @return 删除条数
     */
    int deleteBatch(String[] relateIds);

    /**
     * 建立模板和商品种类关系
     * @param tempalteId
     * @param categoryIds
     * @return
     */
    Result buildRelate(String tempalteId, String[] categoryIds);
}
