package com.diaoyun.zion.chinafrica.enums;


import com.diaoyun.zion.master.enums.EnumItemable;

/**
 * 发货状态
 * 
 * @author G
 */
public enum DeliveryStatusEnum implements EnumItemable<DeliveryStatusEnum> {

	PROCESSING("等待处理", 0),
	PURCHASE("已经代购", 10),
	ON_LOAD("正在配送", 20),
	WAREHOUSE("已到达中国仓", 30),
	ON_AFRICA("正运往非洲", 40),
	ARRIVALS("到达", 50);

	private String label;
	private Integer value;


	DeliveryStatusEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return this.label;
	}

	public Integer getValue() {
		return this.value;
	}
}
