package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Zara西班牙时尚品牌数据爬虫
 * TODO 数据未处理完全
 */
@Component("zaraSpider")
public class ZaraSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    //西班牙时尚品牌数据爬虫
    private static final String zaraUrl = "https://www.zara.cn/cn/zh/";

    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        JSONObject resultObj;
        // 获取url中的网页内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARA.getValue());
        // 截取主要的 Json 内容
        resultObj = JsoupUtil.getZara(content);
        ProductResponse productResponse = SpiderUtil.formatNikeProductResponse(resultObj);
        resultObj = JSONObject.fromObject(productResponse);
        //翻译
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 根据首位字符串内容进行截取
     * @param jsonStr
     * @param startStr 起始字符串
     * @param lastStr 结尾字符串(不包含)
     * @return
     */
    private static String getDataJson(String jsonStr, String startStr, String lastStr) {
        int startIndex = jsonStr.indexOf(startStr);
        int lastIndex = jsonStr.lastIndexOf(lastStr);
        return  jsonStr.substring(startIndex, lastIndex);
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        // URL链接
        String targetUrl = "https://www.zara.cn/cn/zh/%E5%BA%9C%E7%BB%B8%E9%95%BF%E7%89%88%E8%A1%AC%E8%A1%AB-p08053157.html?v1=31979171&v2=1319321";
        // 获取网页内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARA.getValue());
        // 截取主要的商品数据
        int labelHeadIndex = content.indexOf("dataLayer");
        int labelTailIndex = content.lastIndexOf(";window.zara.viewPayload");
        String abv = content.substring(labelHeadIndex, labelTailIndex).replace("dataLayer = ", "");
        System.err.println(abv);

        // 转换为 Json 格式
        JSONObject json = JSONObject.fromObject(abv);
//        System.err.println(json);

        // product 对象节点
        JSONObject responseData = json.getJSONObject("product");
//        System.err.println(responseData);

        // detail 对象节点
        JSONObject details = responseData.getJSONObject("detail");
//        System.err.println(details);

        // colors 数组节点
        JSONArray colorsArray = details.getJSONArray("colors");
        Map<Integer, JSONObject> colorMap = new HashMap<>();
        for (int i = 0; i < colorsArray.size(); i++) {
            colorMap.put(i, colorsArray.getJSONObject(i));
        }
        System.out.println(colorMap);

        // TODO 取出颜色属性


        // sizes 数组节点
        Map<Integer, JSONObject> sizesMap = new HashMap<>();
        for(Map.Entry<Integer, JSONObject> entry : colorMap.entrySet()){
            // 遍历出每个 colors 对象节点
            JSONObject colors = entry.getValue();
            JSONArray sizesArray = colors.getJSONArray("sizes");
            for (int i = 0; i < sizesArray.size(); i++) {
                sizesMap.put(i, sizesArray.getJSONObject(i));
            }
        }
        System.out.println(sizesMap);

        // TODO 取出价格和尺码属性


        // TODO 取出图片属性(图片实体类未知)
    }
}
