package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 西班牙年轻时尚品牌-pullandbear 数据爬虫
 *
 * TODO 图片路径未处理
 * 图片路径为：
 */
@Component("pullandbearSpider")
public class PullandbearSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    //PullandBear商品详情
    private static final String pullandbearUrl="https://www.pullandbear.cn/itxrest/2/catalog/store/24009528/20309423/category/0/product/";

    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 提取链接中的商品 id 信息
        String pId = targetUrl.substring(targetUrl.lastIndexOf("p")+1, targetUrl.lastIndexOf(".html"));
        // 组成链接并获取商品详情信息的 Json
        targetUrl = pullandbearUrl + pId + "/detail?languageId=-7&appId=1";
        // 获取网页内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.PULLANDBEAR.getValue());
        // 转换为Json格式
        JSONObject json = JSONObject.fromObject(content);
        // 简化Json格式
        json = getMainData(json, content);
        return json;
    }

    /**
     * 简化Json格式
     * @param json
     * @param content
     * @return
     */
    private JSONObject getMainData(JSONObject json, String content) {
        json = json.getJSONArray("bundleProductSummaries").getJSONObject(0);
        // 商品id
        String productId = json.getString("id");
        // 商品名称
        String productName = json.getString("name");
        JSONArray colors = json.getJSONObject("detail").getJSONArray("colors");
        // 返回数据
        JSONObject returnJson = new JSONObject();
        returnJson.put("id", productId);
        returnJson.put("name", productName);
        returnJson.put("data", colors);
        return returnJson;
    }

}


