package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.*;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * nike数据爬虫
 */
@Component("nikeItemSpider")
public class NikeItemSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(NikeItemSpider.class);


    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, InterruptedException, ExecutionException, TimeoutException {
        JSONObject resultObj;
        //获取url中的网页内容 >
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.NIKE.getValue());
        //获取商品相关信息，详情放在<script> 标签的 window.INITIAL_REDUX_STATE 变量中
        resultObj = JsoupUtil.getItemDetailByName(content, "window.INITIAL_REDUX_STATE");
        //格式化为封装数据
        ProductResponse productResponse = SpiderUtil.formatNikeProductResponse(resultObj);
        resultObj = JSONObject.fromObject(productResponse);
        //翻译
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }


}
