$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfuseraddressr/list',
        colModel: [
			{label: 'userAddressId', name: 'userAddressId', index: 'user_address_id', key: true, hidden: true},
			{label: '用户id', name: 'userId', index: 'user_id', width: 80},
			{label: '地址id', name: 'addressId', index: 'address_id', width: 80},
			{label: '是否有效', name: 'enableFlag', index: 'enable_flag', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfUserAddressR: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfUserAddressR = {};
		},
		update: function (event) {
            let userAddressId = getSelectedRow("#jqGrid");
			if (userAddressId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(userAddressId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfUserAddressR.userAddressId == null ? "../tbcfuseraddressr/save" : "../tbcfuseraddressr/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfUserAddressR),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let userAddressIds = getSelectedRows("#jqGrid");
			if (userAddressIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfuseraddressr/delete",
                    params: JSON.stringify(userAddressIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(userAddressId){
            Ajax.request({
                url: "../tbcfuseraddressr/info/"+userAddressId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfUserAddressR = r.tbCfUserAddressR;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});