$(function () {
    $("#jqGrid").Grid({
        url: '../tbcftax/list',
        colModel: [
			{label: 'taxId', name: 'taxId', index: 'tax_id', key: true, hidden: true},
			{label: '商品类型id', name: 'categoryId', index: 'category_id', width: 80, hidden: true},
			{label: '商品类型名', name: 'categoryName', index: 'category_name', width: 80, hidden: true},
			{label: '起征点', name: 'mixAmount', index: 'mix_amount', width: 80, hidden: true},
			{label: '税率', name: 'taxRate', index: 'tax_rate', width: 80},
			{label: '启用状态', name: 'enableFlag', index: 'enable_flag', width: 80, hidden: true}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfTax: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfTax = {};
		},
		update: function (event) {
            let taxId = getSelectedRow("#jqGrid");
			if (taxId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(taxId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfTax.taxId == null ? "../tbcftax/save" : "../tbcftax/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfTax),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let taxIds = getSelectedRows("#jqGrid");
			if (taxIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcftax/delete",
                    params: JSON.stringify(taxIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(taxId){
            Ajax.request({
                url: "../tbcftax/info/"+taxId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfTax = r.tbCfTax;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});