$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfplatformorder/list',
        colModel: [
			{label: 'relativeId', name: 'relativeId', index: 'relative_id', key: true, hidden: true},
			{label: '订单id', name: 'orderId', index: 'order_id', width: 80},
			{label: '第三方订单id', name: 'pOrderId', index: 'p_order_id', width: 80},
			{label: '第三方平台名', name: 'platformName', index: 'platform_name', width: 80},
			{label: '第三方平台编号', name: 'platformCode', index: 'platform_code', width: 80},
			{label: '第三方发货地址', name: 'pDeliveryAddress', index: 'p_delivery_address', width: 80},
			{label: '代购人', name: 'userName', index: 'user_name', width: 80},
			{label: '代购人id', name: 'userId', index: 'user_id', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80},
			{label: '实际付款', name: 'realityPay', index: 'reality_pay', width: 80},
			{label: '第三方快递单号', name: 'pExpressNumber', index: 'p_express_number', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfPlatformOrder: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfPlatformOrder = {};
		},
		update: function (event) {
            let relativeId = getSelectedRow("#jqGrid");
			if (relativeId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(relativeId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfPlatformOrder.relativeId == null ? "../tbcfplatformorder/save" : "../tbcfplatformorder/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfPlatformOrder),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let relativeIds = getSelectedRows("#jqGrid");
			if (relativeIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfplatformorder/delete",
                    params: JSON.stringify(relativeIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(relativeId){
            Ajax.request({
                url: "../tbcfplatformorder/info/"+relativeId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfPlatformOrder = r.tbCfPlatformOrder;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});