$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfpagevisit/list',
        colModel: [
			{label: 'recordId', name: 'recordId', index: 'record_id', key: true, hidden: true},
			{label: '页面或者站点id', name: 'pageId', index: 'page_id', width: 80},
			{label: '访问次数', name: 'pageCount', index: 'page_count', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfPageVisit: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfPageVisit = {};
		},
		update: function (event) {
            let recordId = getSelectedRow("#jqGrid");
			if (recordId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(recordId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfPageVisit.recordId == null ? "../tbcfpagevisit/save" : "../tbcfpagevisit/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfPageVisit),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let recordIds = getSelectedRows("#jqGrid");
			if (recordIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfpagevisit/delete",
                    params: JSON.stringify(recordIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(recordId){
            Ajax.request({
                url: "../tbcfpagevisit/info/"+recordId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfPageVisit = r.tbCfPageVisit;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});