$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfissuecoupon/list',
        colModel: [
			{label: 'couponIssuetableId', name: 'couponIssuetableId', index: 'coupon_issuetable_id', key: true, hidden: true},
			{label: '发放id', name: 'issueId', index: 'issue_id', width: 80, hidden: true},
			{label: '优惠券类型', name: 'couponCategoryName', index: 'couponCategoryName', width: 80},
			{label: '优惠券id', name: 'couponId', index: 'coupon_id', width: 80, hidden: true},
			{label: '优惠券名称', name: 'couponTitle', index: 'coupon_title', width: 80},
			{label: '用户id', name: 'userId', index: 'user_id', width: 80,hidden: true},
			{label: '用户昵称', name: 'nick', index: 'nick', width: 80},
			{label: '创建日期', name: 'createTime', index: 'create_time', width: 80},
			{label: '是否已经使用(0已使用，1未使用)', name: 'enableFlag', index: 'enable_flag', width: 80}
			]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfIssueCoupon: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfIssueCoupon = {};
		},
		update: function (event) {
            let couponIssuetableId = getSelectedRow("#jqGrid");
			if (couponIssuetableId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(couponIssuetableId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfIssueCoupon.couponIssuetableId == null ? "../tbcfissuecoupon/save" : "../tbcfissuecoupon/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfIssueCoupon),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let couponIssuetableIds = getSelectedRows("#jqGrid");
			if (couponIssuetableIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfissuecoupon/delete",
                    params: JSON.stringify(couponIssuetableIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(couponIssuetableId){
            Ajax.request({
                url: "../tbcfissuecoupon/info/"+couponIssuetableId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfIssueCoupon = r.tbCfIssueCoupon;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});