$(function () {
    $("#jqGrid").Grid({
        url: '../tbcffeedback/list',
        colModel: [
			{label: 'feedbackId', name: 'feedbackId', index: 'feedback_id', key: true, hidden: true},
			{label: '问题', name: 'question', index: 'question', width: 80},
			{label: '是否展示,1展示，0不展示', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80, hidden: true},
			{label: '反馈问题类型，1为填写类型', name: 'questionType', index: 'question_type', width: 80, hidden: true},
			{label: '排序，数字，倒序', name: 'sort', index: 'sort', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfFeedback: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfFeedback = {};
		},
		update: function (event) {
            let feedbackId = getSelectedRow("#jqGrid");
			if (feedbackId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(feedbackId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfFeedback.feedbackId == null ? "../tbcffeedback/save" : "../tbcffeedback/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfFeedback),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let feedbackIds = getSelectedRows("#jqGrid");
			if (feedbackIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcffeedback/delete",
                    params: JSON.stringify(feedbackIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(feedbackId){
            Ajax.request({
                url: "../tbcffeedback/info/"+feedbackId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfFeedback = r.tbCfFeedback;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});