$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfexpresstemplate/list',
        colModel: [
			{label: 'templateId', name: 'templateId', index: 'template_id', key: true, hidden: true},
			{label: '模板标题', name: 'templateTitle', index: 'template_title', width: 80},
			{label: '商品类型 暂无用，用tb_cf_exp_cat_rel关联', name: 'itemCategoryId', index: 'item_category_id', width: 80, hidden: true},
			{label: '快递费', name: 'expressFee', index: 'express_fee', width: 80},
			{label: '国家编号', name: 'countryCode', index: 'country_code', width: 80, hidden: true},
			{label: '创建日期', name: 'createTime', index: 'create_time', width: 80, hidden: true}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfExpressTemplate: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfExpressTemplate = {};
		},
		update: function (event) {
            let templateId = getSelectedRow("#jqGrid");
			if (templateId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(templateId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfExpressTemplate.templateId == null ? "../tbcfexpresstemplate/save" : "../tbcfexpresstemplate/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfExpressTemplate),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let templateIds = getSelectedRows("#jqGrid");
			if (templateIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfexpresstemplate/delete",
                    params: JSON.stringify(templateIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(templateId){
            Ajax.request({
                url: "../tbcfexpresstemplate/info/"+templateId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfExpressTemplate = r.tbCfExpressTemplate;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});