$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfcouponuse/list',
        colModel: [
			{label: 'useId', name: 'useId', index: 'use_id', key: true, hidden: true},
			{label: '用户名称', name: 'name', index: 'name', width: 80},
			{label: '优惠券名称', name: 'title', index: 'title', width: 80},
			{label: '使用时间', name: 'useTime', index: 'use_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfCouponUse: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		handleSubmit1(){
			console.log(111)
		},

		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfCouponUse = {};
		},
		update: function (event) {
            let useId = getSelectedRow("#jqGrid");
			if (useId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(useId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfCouponUse.useId == null ? "../tbcfcouponuse/save" : "../tbcfcouponuse/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfCouponUse),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let useIds = getSelectedRows("#jqGrid");
			if (useIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcouponuse/delete",
                    params: JSON.stringify(useIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(useId){
            Ajax.request({
                url: "../tbcfcouponuse/info/"+useId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfCouponUse = r.tbCfCouponUse;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});