$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfcouponcategory/list',
        colModel: [
			{label: 'couponCategoryId', name: 'couponCategoryId', index: 'coupon_category_id', key: true, hidden: true},
			{label: '优惠券类型名称 ', name: 'couponCategoryName', index: 'coupon_category_name', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfCouponCategory: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
        handleSubmit2(){
            console.log(111)
        },
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfCouponCategory = {};
		},
		update: function (event) {
            let couponCategoryId = getSelectedRow("#jqGrid");
			if (couponCategoryId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(couponCategoryId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfCouponCategory.couponCategoryId == null ? "../tbcfcouponcategory/save" : "../tbcfcouponcategory/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfCouponCategory),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let couponCategoryIds = getSelectedRows("#jqGrid");
			if (couponCategoryIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcouponcategory/delete",
                    params: JSON.stringify(couponCategoryIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(couponCategoryId){
            Ajax.request({
                url: "../tbcfcouponcategory/info/"+couponCategoryId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfCouponCategory = r.tbCfCouponCategory;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});