$(function () {
	$("#jqGrid").Grid({
        url: '../tbcfcoupon/list',
        colModel: [
			{label: 'couponId', name: 'couponId', index: 'coupon_id', key: true, hidden: true},
			{label: '优惠券类型Id ', name: 'couponCategoryId', index: 'couponCategoryId', width: 80 ,hidden:true},
			{label: '优惠券类型 ', name: 'couponCategoryName', index: 'couponCategoryName', width: 80 },
			{label: '可用于类目', name: 'couponUse', index: 'coupon_use', width: 80, hidden: true},
			{label: '优惠券标题', name: 'couponTitle', index: 'coupon_title', width: 80},
			{label: '优惠券图片地址', name: 'couponIcon', index: 'coupon_icon', width: 80},
			{label: '那些站点可以使用', name: 'withStationId', index: 'with_station_id', width: 80, hidden: true},
			{label: '满多少金额可以使用', name: 'withAmount', index: 'with_amount', width: 80},
			{label: '抵扣金额', name: 'deductAmount', index: 'deduct_amount', width: 80},
			{label: '发券数量', name: 'quato', index: 'quato', width: 80},
			{label: '已领取数量', name: 'takeCount', index: 'take_count', width: 80, hidden: true},
			{label: '已使用数量', name: 'usedCount', index: 'used_count', width: 80, hidden: true},
			{label: '发放开始时间', name: 'startTime', index: 'start_time', width: 80},
			{label: '发放结束时间', name: 'endTime', index: 'end_time', width: 80},
			{label: '有效开始时间', name: 'validStartTime', index: 'valid_start_time', width: 80},
			{label: '有效结束时间', name: 'validEndTime', index: 'valid_end_time', width: 80},
			{label: '有效标志', name: 'status', index: 'status', width: 80,formatter:stateFormat},
			{label: '创建人', name: 'createUserId', index: 'create_user_id', width: 80, hidden: true},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80},
			{label: '修改人', name: 'updateUserId', index: 'update_user_id', width: 80, hidden: true},
			{label: '修改时间', name: 'updateTime', index: 'update_time', width: 80, hidden: true},
			{label: '是否为注册就送优惠券', name: 'couponVaild', index: 'coupon_vaild', width: 80, hidden: true}]
    });
});
$(function () {
	$("#jqGrid1").Grid({
		url: '../tbcfcouponIssue/list',
		colModel: [
			{label: 'couponIssueId', name: 'couponIssueId', index: 'coupon_issue_id', key: true, hidden: true},
			{label: '优惠券名称', name: 'couponId', index: 'coupon_id', width: 80},
			{label: '用户状态', name: 'userStatus', index: 'user_status', width: 80,formatter:userStatusFormat},
			{label: '用户等级', name: 'userLevel', index: 'user_level', width: 80,formatter:userLevelFormat}]
	});
});
$(function () {
	$("#jqGrid2").Grid({
		url: '../tbCfCouponCategory/list',
		colModel: [
			{label: '优惠券类型ID', name: 'couponCategoryId', index: 'coupon_category_id', key: true},
			{label: '优惠券类型名称 ', name: 'couponCategoryName', index: 'coupon_category_name', width: 80}]
	});
});

let vm = new Vue({

	el: '#rrapp',
	data: {
		takeVisible:false,
		issueVisible:false,
		useVisible:false,
		takeTitle:"领取详情(已领取数：0)",
		issueTitle:"领取详情(已领取数：0)",
		//领取优惠券情况
		takeData:[],
		issueData:[],
		userStatusOptions:[{
				value:'10',
				label:'未下单的用户'
		},{
				value:'20',
				label:'新用户'
		},{
				value:'30',
				label:'已下单的用户'
		},{
				value:'40',
				label:'添加购物车的用户'
		}],
		userLevelOptions:[{
			value:'10',
			label:'1'
		},{
			value:'20',
			label:'2'
		},{
			value:'30',
			label:'3'
		},{
			value:'40',
			label:'4'
		}],
        showEdit: true,
		showList: true,
		showCategory: true,
		title: null,
		tbCfCoupon: {},
		tbCfCouponIssue: {},
		tbCfCouponCategory: {},
		//优惠券类型
		CouponCategory:null,
		Coupon:null,
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		},
		pickerOptions: {
			disabledDate(time) {
				return time.getTime() > Date.now();
			},
			shortcuts: [{
				text: '今天',
				onClick(picker) {
					picker.$emit('pick', new Date());
				}
			}, {
				text: '昨天',
				onClick(picker) {
					const date = new Date();
					date.setTime(date.getTime() - 3600 * 1000 * 24);
					picker.$emit('pick', date);
				}
			}, {
				text: '一周前',
				onClick(picker) {
					const date = new Date();
					date.setTime(date.getTime() - 3600 * 1000 * 24 * 7);
					picker.$emit('pick', date);
				}
			}]
		}
	},
	methods: {
		changeCouponCategory(){
			let url = `/africa_shop/tbcfcouponcategory/queryByCouponCategoryId?categoryId=${this.tbCfCoupon.couponCategoryId}`;
			console.log('url',url)
			let that = this;
			Ajax.request({
				url: url,
				type: "get",
				contentType: "application/json",
				successCallback: function (r4) {
					console.log('res',r4)
					if(r4.code===0){
						that.couponCategory = r4.list
						console.log(that.couponCategory)
					}
				}
			});
		},
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfCoupon = {};
		},
		update: function (event) {
            let couponId = getSelectedRow("#jqGrid");
			if (couponId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(couponId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfCoupon.couponId == null ? "../tbcfcoupon/save" : "../tbcfcoupon/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfCoupon),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let couponIds = getSelectedRows("#jqGrid");
			if (couponIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcoupon/delete",
                    params: JSON.stringify(couponIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},

		getInfo: function(couponId){
			Ajax.request({
                url: "../tbcfcoupon/info/"+couponId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfCoupon = r.tbCfCoupon;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},

                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},

        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
		 handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },

        handleReset: function (name) {
            handleResetForm(this, name);
        },

		//获取领取详情
		showTake: function () {
			let couponId = getSelectedRow("#jqGrid");
			if (couponId == null) {
				return;
			}
			vm.takeVisible = true;
			vm.getCouponTakeList(couponId);
		},
		//获取发放详情
		showIssue: function () {
			let couponId = getSelectedRow("#jqGrid");
			if (couponId == null) {
				return;
			}
			vm.issueVisible = true;
			vm.getCouponIssueList(couponId);
		},
		//获取优惠券领取情况
		getCouponTakeList: function (couponId) {
			Ajax.request({
				url: "../tbcfcoupon/take/" + couponId,
				async: true,
				successCallback: function (r5) {
					vm.takeData = r5.list;
					var length=0;
					if(!!vm.takeData) {
						length=vm.takeData.length;
					}
					vm.takeTitle="领取详情(已领取数："+length+")";
				}
			});
		},
		//获取优惠券发放情况
		getCouponIssueList: function (couponId) {
			Ajax.request({
				url: "../tbcfcoupon/issue/" + couponId,
				async: true,
				successCallback: function (r6) {
					vm.issueData = r6.list;
					var length=0;
					if(!!vm.issueData) {
						length=vm.issueData.length;
					}
					vm.issueTitle="领取详情(已领取数："+length+")";
				}
			});
		},
		insertcoupon:function(){
			this.showCategory=false
			vm.title="新增优惠券类型";
			vm.tbCfCouponCategory={};
			console.log("insertcoupon")
		},
		edit: function(){
			this.showEdit=false
			vm.title = "设置优惠券发放";
			vm.tbCfCoupon = {};
		},

		saveOrUpdate1: function (event) {
			let url = vm.tbCfCoupon.couponIssueId == null ? "../tbcfcouponissue/save" : "../tbcfcouponissue/update";
			Ajax.request({
				url: url,
				params: JSON.stringify(vm.tbCfCoupon),
				type: "POST",
				contentType: "application/json",
				successCallback: function (r1) {
					alert('操作成功', function (index) {
						vm.reload1();
					});
				}
			});
		},

		getInfo1: function(couponIssueId){
			Ajax.request({
				url: "../tbcfcoupon/info/"+couponIssueId,
				async: true,
				successCallback: function (r1) {
					vm.tbCfCouponIssue = r1.tbCfCouponIssue;
				}
			});
		},
		reload1: function (event) {
			vm.showEdit = true;
			let page = $("#jqGrid1").jqGrid('getGridParam', 'page');
			$("#jqGrid1").jqGrid('setGridParam', {
				postData: {'name': vm.q.name},
				page: page
			}).trigger("reloadGrid");
			vm.handleReset1('formValidate1');
		},

		handleSubmit1: function (name) {
			handleSubmitValidate(this, name, function () {
				vm.saveOrUpdate1()
			});
		},
		handleReset1: function (name) {
			handleResetForm(this, name);
		},


		saveOrUpdate2: function (event) {
			let url = vm.tbCfCoupon.couponCategoryId == null ? "../tbcfcouponcategory/save" : "../tbcfcouponcategory/update";
			Ajax.request({
				url: url,
				params: JSON.stringify(vm.tbCfCoupon),
				type: "POST",
				contentType: "application/json",
				successCallback: function (r2) {
					alert('操作成功', function (index) {
						vm.reload2();
					});
				}
			});
		},

		getInfo2: function(couponCategoryId){
			Ajax.request({
				url: "../tbcfcouponcategory/info/"+couponCategoryId,
				async: true,
				successCallback: function (r2) {
					vm.tbCfCouponCategory = r2.tbCfCouponCategory;
				}
			});
		},
		reload2: function (event) {
			vm.showCategory = true;
			let page = $("#jqGrid2").jqGrid('getGridParam', 'page');
			$("#jqGrid2").jqGrid('setGridParam', {
				postData: {'name': vm.q.name},
				page: page
			}).trigger("reloadGrid");
			vm.handleReset2('formValidate2');
		},

		handleSubmit2: function (name) {
			handleSubmitValidate(this, name, function () {
				vm.saveOrUpdate2()
			});
		},

		handleReset2: function (name) {
			handleResetForm(this, name);
		}
},
	created(){
		debugger
		var that = this
		$.get('../tbcfcoupon/queryAll',function (res) {
			console.log(res.list)
			that.Coupon = res.list;
		})
		var ta = this
		$.get('../tbcfcouponcategory/queryAll',function (res1) {
		console.log(res1.list)
			ta.CouponCategory=res1.list;
		})
	}
});
