$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfcountryconfig/list',
        colModel: [
			{label: 'configId', name: 'configId', index: 'config_id', key: true, hidden: true},
			{label: '地区编号', name: 'locationCode', index: 'location_code', width: 80},
			{label: '地区类型', name: 'locationType', index: 'location_type', width: 80},
			{label: '地区名称', name: 'locationName', index: 'location_name', width: 80},
			{label: '上级编号', name: 'parentCode', index: 'parent_code', width: 80},
			{label: '英文名', name: 'englishName', index: 'english_name', width: 80},
			{label: '缩写名', name: 'shortName', index: 'short_name', width: 80},
			{label: '是否有下一级', name: 'endFlag', index: 'end_flag', width: 80},
			{label: '是否启用', name: 'enableFlag', index: 'enable_flag', width: 80,formatter:yesOrNoFormat}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfCountryConfig: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfCountryConfig = {};
		},
		update: function (event) {
            let configId = getSelectedRow("#jqGrid");
			if (configId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(configId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfCountryConfig.configId == null ? "../tbcfcountryconfig/save" : "../tbcfcountryconfig/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfCountryConfig),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let configIds = getSelectedRows("#jqGrid");
			if (configIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcountryconfig/delete",
                    params: JSON.stringify(configIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(configId){
            Ajax.request({
                url: "../tbcfcountryconfig/info/"+configId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfCountryConfig = r.tbCfCountryConfig;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});