$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfcartrecordr/list',
        colModel: [
			{label: 'cartRecordId', name: 'cartRecordId', index: 'cart_record_id', key: true, hidden: true},
			{label: '商品id', name: 'itemId', index: 'item_id', width: 80},
			{label: '用户id', name: 'userId', index: 'user_id', width: 80},
			{label: '是否已经被勾选，0未勾选，1勾选', name: 'checkFlag', index: 'check_flag', width: 80},
			{label: '是否有效', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfCartRecordR: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfCartRecordR = {};
		},
		update: function (event) {
            let cartRecordId = getSelectedRow("#jqGrid");
			if (cartRecordId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(cartRecordId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfCartRecordR.cartRecordId == null ? "../tbcfcartrecordr/save" : "../tbcfcartrecordr/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfCartRecordR),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let cartRecordIds = getSelectedRows("#jqGrid");
			if (cartRecordIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfcartrecordr/delete",
                    params: JSON.stringify(cartRecordIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(cartRecordId){
            Ajax.request({
                url: "../tbcfcartrecordr/info/"+cartRecordId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfCartRecordR = r.tbCfCartRecordR;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});