package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfToiCouponDao;
import com.diaoyun.zion.chinafrica.entity.CouponItem;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfToiCouponEntityExtends;
import com.diaoyun.zion.chinafrica.entity.TbCfToicouponEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfToiCouponEntityExtends;
import com.diaoyun.zion.chinafrica.service.TbCfToiCouponService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Service实现类
 *
 * @author lipengjun
 * @date 2019-11-20 19:37:20
 */
@Service("tbCfToiCouponService")
public class TbCfToiCouponServiceImpl implements TbCfToiCouponService {
    @Autowired
    private TbCfToiCouponDao tbCfToiCouponDao;

    @Override
    public Result<CouponItem> queryCouponByUserId(String userId) {
        List<TbCfToiCouponEntityExtends> list = tbCfToiCouponDao.queryCouponByUserId(userId);
        CouponItem couponItem=new CouponItem();
        couponItem.setCouponList(list);
        return new Result<>(couponItem);
    }

    @Override
    public TbCfToicouponEntity queryObject(String toitableId) {
        return tbCfToiCouponDao.queryObject(toitableId);
    }

    @Override
    public List<TbCfToicouponEntity> queryList(Map<String, Object> map) {
        return tbCfToiCouponDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfToiCouponDao.queryTotal(map);
    }

    @Override
    public int save(TbCfToicouponEntity tbCfToicoupon) {
        tbCfToicoupon.setToitableId(IdUtil.createIdbyUUID());
        return tbCfToiCouponDao.save(tbCfToicoupon);
    }


    @Override
    public int update(TbCfToicouponEntity tbCfToicoupon) {
        return tbCfToiCouponDao.update(tbCfToicoupon);
    }

    @Override
    public int delete(String toitableId) {
        return tbCfToiCouponDao.delete(toitableId);
    }

    @Override
    public int deleteBatch(String[] toitableIds) {
        return tbCfToiCouponDao.deleteBatch(toitableIds);
    }


}
