package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfReplyDao;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfReplyEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfReplyEntityExtends;
import com.diaoyun.zion.chinafrica.service.TbCfReplyService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * Service实现类
 *
 * @author lipengjun
 * @date 2019-11-18 15:10:45
 */
@Service("tbCfReplyService")
public class TbCfReplyServiceImpl implements TbCfReplyService {
    private static Logger logger = LoggerFactory.getLogger(TbCfReplyServiceImpl.class);
    @Autowired
    private TbCfReplyDao tbCfReplyDao;

    @Override
    public TbCfReplyEntity queryObject(String id) {
        return tbCfReplyDao.queryObject(id);
    }

    @Override
    public List<TbCfReplyEntity> queryList(Map<String, Object> map) {
        return tbCfReplyDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfReplyDao.queryTotal(map);
    }

    @Override
    public int save(TbCfReplyEntity tbCfReply) {
        tbCfReply.setId(IdUtil.createIdbyUUID());
        return tbCfReplyDao.save(tbCfReply);
    }

    @Override
    public int update(TbCfReplyEntity tbCfReply) {
        return tbCfReplyDao.update(tbCfReply);
    }

    @Override
    public int delete(String id) {
        return tbCfReplyDao.delete(id);
    }

    @Override
    public int deleteBatch(String[] ids) {
        return tbCfReplyDao.deleteBatch(ids);
    }

    @Override
    public Result queryReplys(String commentId, Integer pageNum, Integer pageSize) {
        Result result = new Result();
        try {
            startPage(pageNum, pageSize);
            List<TbCfReplyEntityExtends> replys = tbCfReplyDao.queryReplys(commentId);
            PageInfo<TbCfReplyEntityExtends> pageInfo = new PageInfo<>(replys);
            result.setData(pageInfo);
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    @Override
    public Result addReply(TbCfReplyEntity reply) {
        Result result = new Result();
        try {
            reply.setId(IdUtil.createIdbyUUID());
            reply.setReplyType(0);
            reply.setDelFlag(0);
            reply.setCreateTime(new Date());
            reply.setUpdateTime(new Date());
            int i = tbCfReplyDao.save(reply);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Reply successful!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Reply failed!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    @Override
    public Result delReply(String replyId) {
        Result result = new Result();
        try {
            TbCfReplyEntity reply = tbCfReplyDao.queryObject(replyId);
            reply.setDelFlag(1);
            reply.setUpdateTime(new Date());
            int i = tbCfReplyDao.update(reply);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Deleted successfully!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Deletion failed!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }
}
