package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.bis.impl.NetWorkSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.factory.ItemSpiderFactory;
import com.diaoyun.zion.chinafrica.service.SpiderService;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

/**
 * 爬虫服务类
 *
 * @author G
 */
@Service("spiderService")
public class SpiderServiceImpl implements SpiderService {

    /**
     * 判断链接属于哪个平台
     * @param targetUrl 在商品详情页截取到的路径
     * @return 对应的爬虫
     */
    @Override
    public JSONObject getItemDetail(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException {
        PlatformEnum platformEnum=judgeUrlType(targetUrl);
        IItemSpider iItemSpider=ItemSpiderFactory.getSpider(platformEnum);
        return iItemSpider.captureItem(targetUrl);
    }

    /**
     * 获取汇率
     * @param currency FOREXUSDCNY 人民币换美元
     * @return 汇率
     */
    @Override
    public BigDecimal getExchangeRate(String currency) throws IOException, URISyntaxException {
        //默认人民币换美元
        if(StringUtils.isBlank(currency)) {
            currency="FOREXUSDCNY";
        }
        return NetWorkSpider.getRateFromHexun(currency);
    }

    /**
     * 判断链接属于哪个平台
     * 先通过平台名判断所属平台，之后使用正则表达式判断是否为平台的商品详情页
     * @param targetUrl 在app访问平台时获取到的链接
     * @return 对应的爬虫
     */
    private PlatformEnum judgeUrlType(String targetUrl) {
        PlatformEnum platformEnum = PlatformEnum.UN;
        if (targetUrl.contains("taobao.com") && (targetUrl.contains("item.htm") || targetUrl.contains("detail.htm"))) {
            platformEnum = PlatformEnum.TB;
        } else if (targetUrl.contains("tmall.com/item.htm")) {
            platformEnum = PlatformEnum.TM;
        } else if (targetUrl.contains("pullandbear") && Pattern.matches("^.*pullandbear\\.cn/.*-c\\d{5,10}p\\d{9,10}.html\\?cS=\\d*$", targetUrl)) {
            platformEnum = PlatformEnum.PULLANDBEAR;
        } else if(targetUrl.contains("www.gap.cn/pdp/")) {
            platformEnum=PlatformEnum.GAP;
        } else if(targetUrl.contains("www.nike.com/cn/t/")) {
            platformEnum=PlatformEnum.NIKE;
        } else if(targetUrl.contains("afrieshop") /*|| targetUrl.contains("afri-eshop")*/ && targetUrl.contains("/products/")) {
            platformEnum=PlatformEnum.AfriEshop;
        } else if (targetUrl.contains("zara") && Pattern.matches("^.*zara.cn.*-p\\d{8,10}.html.*$", targetUrl)) {
            platformEnum = PlatformEnum.ZARA;
        } else if (targetUrl.contains("uniqlo") && Pattern.matches("^.*uniqlo.*\\/\\#\\/product\\?pid=u\\d+$", targetUrl)) {
            platformEnum = PlatformEnum.UNIQLO;
        } else if (targetUrl.contains("hm") && Pattern.matches("^.*hm.com.cn\\/.*\\/\\d+.html$", targetUrl)) {
            platformEnum = PlatformEnum.HM;
        } else if(targetUrl.contains("adidas") && Pattern.matches("^.*adidas.*\\/item\\/\\w{6,10}.*$", targetUrl)) {
            platformEnum=PlatformEnum.ADIDAS;
        } else if(targetUrl.contains("lily")) {
            platformEnum=PlatformEnum.LILY;
        } else if(targetUrl.contains("eifini")) { 
            platformEnum=PlatformEnum.EIFINI;
        } else if(targetUrl.contains("ur") && Pattern.matches("^.*ur.*\\/product\\/.*productColorId=\\w{24,}$", targetUrl)) {
            platformEnum=PlatformEnum.URBANREVIVO;
        } else if(targetUrl.contains("abercrombie") && Pattern.matches("^.*abercrombie.*\\/anf-\\d{6,}.*$", targetUrl)) {
            platformEnum=PlatformEnum.ABERCROMBIEFITCH;
        } else if(targetUrl.contains("underarmour") && Pattern.matches("^.*underarmour.*\\/p\\d+-\\d+.*$", targetUrl)) {
            platformEnum=PlatformEnum.UNDERARMOUR;
        } else if(targetUrl.contains("ochirly") && Pattern.matches("^.*ochirly.*\\/p\\/.*\\w{10,}.*$", targetUrl)) {
            platformEnum=PlatformEnum.OCHIRLY;
        } else if(targetUrl.contains("esprit") && Pattern.matches("^.*esprit.*\\/product\\/\\w{24,}.html.*$", targetUrl)) {
            platformEnum=PlatformEnum.ESPRIT;
        } else if(targetUrl.contains("levi") && Pattern.matches("^.*levi.com.*\\/product\\/\\w{32}.html.*styleNo=.*$", targetUrl)) {
            platformEnum=PlatformEnum.LEVI;
        } else if(targetUrl.contains("moco") && Pattern.matches("^.*moco.com\\/moco/.*\\/p\\/\\w{10,}.*$", targetUrl)) {
            platformEnum=PlatformEnum.MOCO;
        } else if (targetUrl.contains("massimodutti") && Pattern.matches("^.*massimodutti.cn.*\\/.*-c\\d+p\\d+.html.*$", targetUrl)) {
            platformEnum = PlatformEnum.MASSIMODUTTI;
        } else if (targetUrl.contains("coach") && Pattern.matches("^.*coach.com\\/.*\\/.*.html\\?c=\\d+$", targetUrl)) {
            platformEnum = PlatformEnum.COACH;
        } else if (targetUrl.contains("revolve") && Pattern.matches("^.*revolve.*\\/.*\\/dp\\/\\w+-\\w+\\/.*$", targetUrl)) {
            platformEnum = PlatformEnum.REVOLVE;
        } else if (targetUrl.contains("vans") && Pattern.matches("^.*vans.com.*\\/product-\\d+.*$", targetUrl)) {
            platformEnum = PlatformEnum.VANS;
        } else if (targetUrl.contains("zarahome") && Pattern.matches("^.*zarahome.*\\/.*c\\d+p\\d+.html.*$", targetUrl)) {
            platformEnum = PlatformEnum.ZARAHOME;
        } else if (targetUrl.contains("oysho") && Pattern.matches("^.*oysho.*\\/.*-c\\d+p\\d+.html\\?origenId=\\d+$", targetUrl)) {
            platformEnum = PlatformEnum.OYSHO;
        } else if (targetUrl.contains("stradivarius") && Pattern.matches("^.*stradivarius.*\\/.*c\\d+p\\d+.html.*$", targetUrl)) {
            platformEnum = PlatformEnum.STRADIVARIUS;
        } else if (targetUrl.contains("maje") && Pattern.matches("^.*maje.*/\\w{8,}.html.*$", targetUrl)) {
            platformEnum = PlatformEnum.MAJE;
        } else if (targetUrl.contains("gucci") && Pattern.matches("^.*gucci.*pr\\/\\w{10,}.*$", targetUrl)) {
            platformEnum = PlatformEnum.GUCCI;
        } else if (targetUrl.contains("burberry") && Pattern.matches("^.*burberry.*\\/.*-p\\d{8,}$", targetUrl)) {
            platformEnum = PlatformEnum.BURBERRY;
        } else if (targetUrl.contains("prada") && Pattern.matches("^.*prada.*\\/products.*$", targetUrl)) {
            platformEnum = PlatformEnum.PRADA;
        } else if (targetUrl.contains("fendi") && Pattern.matches("^.*fendi.*\\/p-\\w{10,}.*$", targetUrl)) {
            platformEnum = PlatformEnum.FENDI;
        } else if (targetUrl.contains("apple")&& Pattern.matches("^.*apple.*\\/buy-.*\\/.*\\/\\w+.*$", targetUrl)) {
            platformEnum = PlatformEnum.APPLE;
        } else if (targetUrl.contains("louisvuitton") && Pattern.matches("^.*fendi.*\\/p-\\w{10,}.*$", targetUrl)) {
            platformEnum = PlatformEnum.LOUISVUITTON;
        }
        return platformEnum;
    }
}
