package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCouponEntity;
import com.diaoyun.zion.chinafrica.vo.UserCouponVo;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 优惠券表Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfCouponService {

    /**
     * 根据主键查询实体
     *
     * @param couponId 主键
     * @return 实体
     */
    TbCfCouponEntity queryObject(String couponId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCouponEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCoupon 实体
     * @return 保存条数
     */
    int save(TbCfCouponEntity tbCfCoupon);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCoupon 实体
     * @return 更新条数
     */
    int update(TbCfCouponEntity tbCfCoupon);

    /**
     * 根据主键删除
     *
     * @param couponId
     * @return 删除条数
     */
    int delete(String couponId);

    /**
     * 根据主键批量删除
     *
     * @param couponIds
     * @return 删除条数
     */
    int deleteBatch(String[] couponIds);

    /**
     * 领取优惠券
     * @param couponId
     * @return
     */
    Result takeCoupon(String couponId);
    /**
     * 领取优惠券
     * @param couponId
     * @param userId
     */
    void takeCoupon(String couponId, String userId);

    /**
     * 获取用户所有优惠券
     * @return
     */
    Result<UserCouponVo> getUserCoupons();

    /**
     * 获取优惠券详情
     * @param couponId
     * @return
     */
    Result<TbCfCouponEntity> queryCouponDetail(String couponId);

    /**
     *如果vaild 是1的话就是注册就送该优惠券，可以是送一张也可以送多张
     */
    List<TbCfCouponEntity> getCouponAndVaildAll();

    int updates(TbCfCouponEntity tbCfCoupon);
}
