package com.diaoyun.zion.chinafrica.factory;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.SpringContextUtil;

/**
 * 商品爬虫工厂类
 *
 * @author G
 */
public class ItemSpiderFactory {

    /**
     * 根据获取的路径选择对应的爬虫
     * @param platformEnum 爬虫枚举
     * @return 爬虫实现类
     */
    public static IItemSpider getSpider(PlatformEnum platformEnum) {
        IItemSpider iItemSpider;
        switch (platformEnum.getValue()) {
            case "tb": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("tbItemSpider");
                break;
            }
            case "tm": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("tmItemSpider");
                break;
            }
            case "pullandbear": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("pullandbearSpider");
                break;
            }
            case "gap": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("gapItemSpider");
                break;
            }
            case "zara": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("zaraSpider");
                break;
            }
            case "uniqlo": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("uniqloSpider");
                break;
            }
            case "nike": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("nikeItemSpider");
                break;
            }
            case "adidas": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("adidasSpider");
                break;
            }
            case "hm": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("hmSpider");
                break;
            }
            case "lily": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("lilySpider");
                break;
            }
            case "eifini": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("eifiniSpider");
                break;
            }
            case "urbanrevivo": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("urbanrevivoSpider");
                break;
            }
            case "aberCrombieFitch": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("aberCrombieFitchSpider");
                break;
            }
            case "underarmour": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("underarmourSpider");
                break;
            }
            case "ochirly": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("ochirlySpider");
                break;
            }
            case "esprit": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("espritSpider");
                break;
            }
            case "levi": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("leviSpider");
                break;
            }
            case "moco": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("mocoSpider");
                break;
            }
            case "massimodutti": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("massimoduttiSpider");
                break;
            }
            case "coach": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("coachSpider");
                break;
            }
            case "revolve": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("revolveSpider");
                break;
            }
            case "vans": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("vansSpider");
                break;
            }
            case "zaraHome": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("zaraHomeSpider");
                break;
            }
            case "oysho": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("oyshoSpider");
                break;
            }
            case "stradivarius": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("stradivariusSpider");
                break;
            }
            case "maje": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("majeSpider");
                break;
            }
            case "gucci": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("gucciSpider");
                break;
            }
            case "burberry": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("gucciSpider");
                break;
            }
            case "prada": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("pradaSpider");
                break;
            }
            case "fendi": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("fendiSpider");
                break;
            }
            case "apple": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("appleSpider");
                break;
            }
            case "louisVuitton": {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("louisVuittonSpider");
                break;
            }
            case "Afrishop":{
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("africaShopItemSpider");
                break;
            }
            default: {
                iItemSpider = (IItemSpider) SpringContextUtil.getBean("emptyItemSpider");
                break;
            }
        }
        return iItemSpider;
    }

}
