package com.diaoyun.zion.chinafrica.enums;


import com.diaoyun.zion.master.enums.EnumItemable;

/**
 * 发货状态
 * 
 * @author G
 */
public enum DeliveryStatusEnum implements EnumItemable<DeliveryStatusEnum> {
    /**
     * 代购及物流状态
     */
    PROCESSING("等待处理", 0),
    PURCHASE("已采购并发货", 10),
    ON_LOAD("已到达中国仓", 20),
    ON_AFRICA("已到达非洲仓", 40),
    ARRIVALS("买家已签收", 50);
	private String label;
	private Integer value;

	DeliveryStatusEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	@Override
	public String getLabel() {
		return this.label;
	}

	@Override
	public Integer getValue() {
		return this.value;
	}
}
