package com.diaoyun.zion.chinafrica.enums;


import com.diaoyun.zion.master.enums.EnumItemable;

/**
 * 优惠券类型
 * 
 * @author G
 */
public enum CouponCategoryEnum implements EnumItemable<CouponCategoryEnum> {

	/**
	 * 优惠卷类型枚举
	 */
	SHOP("购物返券", 10),
	REGISTER("注册返券", 20),
	INVITE("邀请返券", 30),
	TAKE("用户领券", 40),
	ISSUE("发放优惠券", 50);

	private String label;
	private Integer value;

	CouponCategoryEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	@Override
	public String getLabel() {
		return this.label;
	}

	@Override
	public Integer getValue() {
		return this.value;
	}
}
