package com.diaoyun.zion.chinafrica.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券表实体
 * 表名 tb_cf_coupon
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@ApiModel
public class TbCfCouponEntity implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     *优惠券发放表id
     */
    @ApiModelProperty("优惠券发放表id")
    private String toitableId;
    /**
     * 优惠券id
     */
    @ApiModelProperty("优惠券id")
    private String couponId;
    /**
     * 优惠券类型
     */
    @ApiModelProperty("优惠券类型")
    private String couponCategoryId;
    /**
     * 优惠券类型
     */
    @ApiModelProperty("优惠券类型名称（暂无用）")
    private String couponCategoryName;
    /**
     * 可用于类目
     */
    @ApiModelProperty("可用于类目（暂无用）")
    private Integer couponUse;
    /**
     * 优惠券标题
     */
    @ApiModelProperty("优惠券标题")
    private String couponTitle;
    /**
     * 优惠券图片地址
     */
    @ApiModelProperty("优惠券图片地址")
    private String couponIcon;
    /**
     * 那些站点可以使用,1111为全部
     */
    @ApiModelProperty("哪些站点可以使用（暂无用）")
    private String withStationId;
    /**
     * 满多少金额可以使用
     */
    @ApiModelProperty("满多少金额可以使用")
    private BigDecimal withAmount;
    /**
     * 抵扣金额
     */
    @ApiModelProperty("抵扣金额")
    private BigDecimal deductAmount;
    /**
     * 发券数量
     */
    @ApiModelProperty("发券数量")
    private Integer quato;
    /**
     * 已领取数量 不更改，因为会被覆盖，改为查询统计来获取已经领取的优惠券数量
     */
    @ApiModelProperty("已领取数量（暂无用）")
    private Integer takeCount;
    /**
     * 已使用数量 不更改，因为会被覆盖，改为查询统计来获取已经使用的优惠券数量
     */
    @ApiModelProperty("已使用数量（暂无用）")
    private Integer usedCount;
    /**
     * 发放开始时间
     */
    @ApiModelProperty("发放开始时间")
    private Date startTime;
    /**
     * 发放结束时间
     */
    @ApiModelProperty("发放结束时间")
    private Date endTime;
    /**
     * 有效开始时间
     */
    @ApiModelProperty("有效开始时间")
    private Date validStartTime;
    /**
     * 有效结束时间
     */
    @ApiModelProperty("有效结束时间")
    private Date validEndTime;
    /**
     * 有效标志,0无效,1生效,2过期
     */
    @ApiModelProperty("有效标志,0无效,1生效,2过期,暂没完全使用")
    private Integer status;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String updateUserId;
    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 设置是否是注册就是的优惠券，(0)默认状态，（1）是用户注册就送这张优惠券
     */
    private Integer couponVaild;
    /**
     * 设置：设置是否是注册就是的优惠券，(0)默认状态，（1）是用户注册就送这张优惠券
     */

    public String getToitableId() {
        return toitableId;
    }

    public void setToitableId(String toitableId) {
        this.toitableId = toitableId;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getCouponCategoryId() {
        return couponCategoryId;
    }

    public void setCouponCategoryId(String couponCategoryId) {
        this.couponCategoryId = couponCategoryId;
    }

    public String getCouponCategoryName() {
        return couponCategoryName;
    }

    public void setCouponCategoryName(String couponCategoryName) {
        this.couponCategoryName = couponCategoryName;
    }

    public Integer getCouponUse() {
        return couponUse;
    }

    public void setCouponUse(Integer couponUse) {
        this.couponUse = couponUse;
    }

    public String getCouponTitle() {
        return couponTitle;
    }

    public void setCouponTitle(String couponTitle) {
        this.couponTitle = couponTitle;
    }

    public String getCouponIcon() {
        return couponIcon;
    }

    public void setCouponIcon(String couponIcon) {
        this.couponIcon = couponIcon;
    }

    public String getWithStationId() {
        return withStationId;
    }

    public void setWithStationId(String withStationId) {
        this.withStationId = withStationId;
    }

    public BigDecimal getWithAmount() {
        return withAmount;
    }

    public void setWithAmount(BigDecimal withAmount) {
        this.withAmount = withAmount;
    }

    public BigDecimal getDeductAmount() {
        return deductAmount;
    }

    public void setDeductAmount(BigDecimal deductAmount) {
        this.deductAmount = deductAmount;
    }

    public Integer getQuato() {
        return quato;
    }

    public void setQuato(Integer quato) {
        this.quato = quato;
    }

    public Integer getTakeCount() {
        return takeCount;
    }

    public void setTakeCount(Integer takeCount) {
        this.takeCount = takeCount;
    }

    public Integer getUsedCount() {
        return usedCount;
    }

    public void setUsedCount(Integer usedCount) {
        this.usedCount = usedCount;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getValidStartTime() {
        return validStartTime;
    }

    public void setValidStartTime(Date validStartTime) {
        this.validStartTime = validStartTime;
    }

    public Date getValidEndTime() {
        return validEndTime;
    }

    public void setValidEndTime(Date validEndTime) {
        this.validEndTime = validEndTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCouponVaild() {
        return couponVaild;
    }

    public void setCouponVaild(Integer couponVaild) {
        this.couponVaild = couponVaild;
    }
}
