package com.diaoyun.zion.chinafrica.dao;


import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfUserVo;
import com.diaoyun.zion.master.dao.BaseDao;

import java.util.List;

/**
 * 用户表Dao
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
public interface TbCfUserInfoDao extends BaseDao<TbCfUserInfoEntity> {

    /**
     * 根据nickname获取用户信息
     *
     * @param nickname
     * @return
     */
    TbCfUserInfoEntity getByNickname(String nickname);

    TbCfUserInfoEntity checkUserByNick(String nick);

    /**
     * 根据用户名、昵称查找
     *
     * @param account
     * @return
     */
    TbCfUserInfoEntity findByAccount(String account);

    TbCfUserInfoEntity findAccount(String account);

    /**
     * 根据手机号查找
     *
     * @param phone
     * @return
     */
    TbCfUserInfoEntity checkUserByPhone(String phone);

    /**
     * 更改用户密码
     *
     * @param userId
     * @param newPassword
     * @return
     */
    int updatePassWord(String userId, String newPassword);

    /**
     * 根据邮箱查询用户信息
     *
     * @return
     */
    TbCfUserInfoEntity findByEmail(String email);

    /**
     * 根据userID获取用户信息
     * @return
     */
    TbCfUserVo queryUserByUserId(String userId);

    List<TbCfUserInfoEntity> selectUserByPhone();

    String findEmails();

    int updateIsSend(String email);
}
