package com.diaoyun.zion.chinafrica.dao;

import com.diaoyun.zion.chinafrica.entity.TbCfPlatformEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 站点商品Dao
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfStationItemDao extends BaseDao<TbCfStationItemEntity> {

    /**
     * 获取商品独立站
     *
     * @return
     */
    List<TbCfStationItemEntity> getItemStationList(String categoryId);

    /**
     * 根据主键一级分类实体集合
     *
     * @return List集合
     */
    List<TbCfStationItemEntity> getGoodsTypeList(String categoryId);

    /**
     * 搜索商品
     *
     * @param name
     * @return
     */
    List<TbCfStationItemEntity> searchItems(@Param("name") String name, @Param("order")String order);


    /**
     * 根据品名查询商品
     *
     * @param descriptionId
     * @return
     */
    List<TbCfStationItemEntity> queryItemByDescription(String descriptionId);
}
