package com.diaoyun.zion.chinafrica.dao;

import com.diaoyun.zion.chinafrica.entity.*;
import com.diaoyun.zion.chinafrica.vo.TbCfOrderVo;
import com.diaoyun.zion.master.dao.BaseDao;

import java.util.Date;
import java.util.List;

/**
 * Dao
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfOrderDao extends BaseDao<TbCfOrderEntity> {

    /**
     * 获取用户订单数据
     *
     * @param userId
     * @param orderStatus OrderStatusEnum
     * @return
     */
    List<TbCfOrderEntity> getUserOrderList(String userId, Integer orderStatus);

    /**
     * 获取订单内商品
     *
     * @param orderId
     * @return
     */
    List<TbCfItemDetailEntity> getOrderItemList(String orderId);

    /**
     * 获取订单内商品
     *
     * @param orderId
     * @return
     */
    List<ItemEntity> getItemList(String orderId);

    /**
     * 获取付款订单
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<TbCfOrderEntity> getOrderListByTime(Date beginDate, Date endDate);

    /**
     * 获取某段时间已发货订单数据
     *
     * @return
     */
    List<TbCfItemShippedEntity> getDeliveryList(Date beginDate, Date endDate);

    /**
     * 根据订单id获取订单实体
     *
     * @param orderId
     * @return
     */
    OrderEntity getOrder(String orderId);


    TbCfCouponEntity queryCouponPrice(String toitableId);

    /**
     * 根据订单id和商品id查询订单记录id //后续根据此id 查询物流信息
     *
     * @param orderId
     * @param itemId
     * @return
     */
    String getOrdersId(String orderId, String itemId);

    /**
     * 汇率转换
     *
     * @param currency
     * @return
     */
    TbCfExchangeEntity currencyConversion(String currency);

    Integer findOrderStatus(String ordersId);
}
