package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfFeeEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFeeService;
import com.diaoyun.zion.master.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

/**
 * 手续费Controller
 */
@RestController
@RequestMapping("fee")
public class TbCfFeeController {

    @Autowired
    private TbCfFeeService tbCfFeeService;

    /**
     * 查看所有运费模板
     */
    @GetMapping("/getRate")
    public Result getRate(Double price) {
        TbCfFeeEntity fee =  tbCfFeeService.getRateFee();
        BigDecimal rate = fee.getFeeRate();
        BigDecimal prices = new BigDecimal(price);
        BigDecimal sum = prices.divide(rate,4,RoundingMode.HALF_UP);

        return new Result<>(sum);
    }


}
