package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.ValidateUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * Zara 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("zaraSpider")
public class ZaraSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Zara 数据爬虫
     *
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARA.getValue());
        int labelHeadIndex = content.indexOf("dataLayer");
        int labelTailIndex = content.lastIndexOf(";window.zara.viewPayload");
        content = content.substring(labelHeadIndex, labelTailIndex).replace("dataLayer = ", "");
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = formatZaraProductResponse(resultObj);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化 Zara 返回数据
     *
     * @param dataMap 主要的 json 数据
     * @return 格式化后的数据
     */
    private ProductResponse formatZaraProductResponse(JSONObject dataMap) throws InterruptedException, ExecutionException, TimeoutException {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(false);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName("Zara");
        itemInfo.setShopUrl(dataMap.getString("backUrl"));
        JSONObject productObj = dataMap.getJSONObject("product");
        itemInfo.setItemId(productObj.getString("id"));
        itemInfo.setTitle(productObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        // 取 colors 节点数组
        TranslateHelper.translateProductResponse(productObj);
        JSONArray colorsArr = productObj.getJSONObject("detail").getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);
            // 取 detailImagesArr 节点数组第一个对象
            JSONObject detailImagesObj_0 = colorsObj.getJSONArray("detailImages").getJSONObject(0);

            String color = colorsObj.getString("name");

            if (ValidateUtils.isContainChinese(color)) {
                List<Map<String, Object>> futureList = new ArrayList<>();
                String productSet=color;
                if (!productSet.isEmpty()) {
                    //调用腾讯ai，翻译color
                    String s = TranslateHelper.translateProps(futureList, productSet);
                    color=s;
                }
            }
                String imageUrl = "http://static.zara.cn/photos//"
                        + detailImagesObj_0.getString("path")
                        + "w/1920/"
                        + detailImagesObj_0.getString("name")
                        + "_1.jpg?ts="
                        + detailImagesObj_0.getString("timestamp");

                if (i == 0) {
                    itemInfo.setPic(imageUrl);
                }

                //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
                ProductProp productPropColor = new ProductProp();
                productPropColor.setPropId(color);
                productPropColor.setPropName(color);
                productPropColor.setImage(imageUrl);
                propSet.add(productPropColor);
                if (productPropSet.get("Color") == null) {
                    productPropSet.put("Color", propSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("Color");
                    propSet.addAll(oldPropSet);
                    productPropSet.put("Color", propSet);
                }
                //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

                // 取 sizes 节点数组
                JSONArray sizesArr = colorsArr.getJSONObject(i).getJSONArray("sizes");
                for (int j = 0; j < sizesArr.size(); j++) {
                    JSONObject sizesObj = sizesArr.getJSONObject(j);

                    ///////////////////////// 获取商品尺码属性 ////////////////////
//                String sizeNo = sizesObj.getString("sku");
                    String size = sizesObj.getString("name");
                    String[] s = size.split(" ");
                    size = s[0];

                    ProductProp productPropSize = new ProductProp();
                    productPropSize.setPropId(size);
                    productPropSize.setPropName(size);
                    sizePropSet.add(productPropSize);
                    if (productPropSet.get("Size") == null) {
                        productPropSet.put("Size", sizePropSet);
                    } else {
                        Set<ProductProp> oldPropSet = productPropSet.get("Size");
                        sizePropSet.addAll(oldPropSet);
                        productPropSet.put("Size", sizePropSet);
                    }
                    ///////////////////////// 获取商品尺码属性 END////////////////////

                    // 库存对应的id(Zara 中以颜色id + 尺码id)
                    String skuStr = ";" + color + ";" + size + ";";

                    //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                    if (productSkuStockList == null) {
                        productSkuStockList = new ArrayList<>();
                    }

                    ProductSkuStock productSkuStock = new ProductSkuStock();
                    productSkuStock.setSkuStr(skuStr);
                    productSkuStock.setSellableQuantity(999);
                    productSkuStockList.add(productSkuStock);
                    dynStock.setProductSkuStockList(productSkuStockList);
                    //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                    //////////////////////////////////// 获取原始价 //////////////////////////////////
                    String fullPrice = sizesObj.getString("price");
                    BigDecimal priceOld = new BigDecimal(fullPrice);
                    BigDecimal div = new BigDecimal("100");
                    BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_DOWN);
                    fullPrice = exchangeRate(priceNew.toString());

                    OriginalPrice originalPrice = new OriginalPrice();
                    originalPrice.setPrice(fullPrice);
                    originalPrice.setSkuStr(skuStr);
                    originalPriceList.add(originalPrice);

                    productResponse.setPrice(fullPrice);
                    productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                    //////////////////////////////////// 获取原始价 END//////////////////////////////////
                }
            }

            // 按照一下顺序进行 json 数据的填充
            productResponse.setProductPropSet(productPropSet);
            productResponse.setPlatform("Zara");
            productResponse.setPromotionList(promotionList);
            productResponse.setOriginalPriceList(originalPriceList);
            productResponse.setItemInfo(itemInfo);
            productResponse.setDynStock(dynStock);
            return productResponse;
        }
    }