package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Revolve  数据爬虫
 * TODO 许多商品获取不到数据，待优化
 * @author 爱酱油不爱醋
 */
@Component("revolveSpider")
public class RevolveSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Revolve  数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.APPLE.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @param content 主要的网页内容
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 转换为 Document 对象
        Document document = Jsoup.parse(content);

        //////////////////////////////////// 获取商品基本信息 //////////////////////////////////////////////////
        itemInfo.setItemId(document.select("input[id=productCode]").attr("value"));
        itemInfo.setShopName("Revolve");
        itemInfo.setShopUrl("http://www.revolve.com");
        itemInfo.setTitle(document.select("meta[property=og:title]").attr("content"));
        //////////////////////////////////// 获取商品基本信息End ///////////////////////////////////////////////

        Elements colorsEle = document.select("fieldset[aria-labelledby=color-sr-text]")
                .select("ul[id=product-swatches]").select("li");
        Elements sizesEle = document.select("div[class=product-sizes product-sections]")
                .select("ul[id=size-ul]").select("li").select("input");

        String fullPrice = document.select("meta[property=wanelo:product:price]").attr("content");
        // 判断货币类型
        if (!"USD".equals(document.select("meta[property=wanelo:product:price:currency]").attr("content"))) {
            fullPrice = SpiderUtil.exchangeRate(fullPrice);
        }

        for (Element colorEle : colorsEle) {
            String colorNo = colorEle.attr("data-swatch-code");
            String color = colorEle.select("img").attr("alt");
            String imgUrl = colorEle.select("img").attr("src");

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }

            for (Element sizeEle : sizesEle) {
                String sizeNo = sizeEle.attr("value");
                String size = sizeEle.attr("data-size");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 商品的库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                // 获取库存数
                int sellableQuantity = Integer.valueOf(sizeEle.attr("data-qty"));

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(sellableQuantity);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END///////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();

                // TODO 转换汇率，目前商品单位是人民币
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Revolve");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
